\version "2.24.0"

\paper {
  %system-system-spacing = 0\mm
  system-system-padding = 5\mm
  markup-system-spacing = #'((basic-distance . 2))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  bottom-margin = 5\mm
  top-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Ca pe Împăratul"
  %subtitle = "(din Concertul coral Nr.1)"
  composer =  \markup \center-column { "Gavriil Musicescu" \small 
  "(1847–1903)" }
  meter = "Allegro"
  tagline=""
}

global = {
  \key d \major
  %\autoBeamOff
  %\cadenzaOn
  \time 4/4
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
 \skip 1 \skip 1 \skip 1 \skip 1 
 Ca pe Îm -- pă -- ra -- tul, Îm -- pă -- ra -- tul,
 Îm -- pă -- ra -- tul tu -- tu -- ror pri -- mind
 de ce -- te, de ce -- te în -- ge -- rești, __
 de ce -- te -- le în -- ge -- rești.
 A -- li -- lu -- ia,  a -- li -- lu -- ia,
 a -- li -- lu -- i -- a.
}

altWords = \lyricmode {
 Ca pe Îm -- pă -- ra -- tul,
 ca pe Îm -- pă -- ra -- tul,
 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
 de __ ce -- te, de 
 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
 a -- li -- lu -- i -- a. 
 
}

tenorWords = \lyricmode {
 Ca pe Îm -- pă -- ra -- tul, Îm -- pă -- ra -- tul
 tu -- tu -- ror pri -- mind,
 pe cel ne vă -- zut, ne vă -- zut,  
 în -- con -- ju -- rat  de __ ce -- te, 
 de ce -- te în -- ge -- rești, 
 de ce -- te -- le în -- ge -- rești.
 A -- li -- lu -- \skip 1 \skip 1 ia,
 a -- li -- lu -- \skip 1 \skip 1 ia, 
 a -- li -- lu -- i -- a.
 
}

bassWords = \lyricmode {
 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
 pe cel
 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
 \skip 1 \skip 1
 de ce -- te, de 
 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
 \skip 1 \skip 1 \skip 1 \skip 1
 A -- li -- lu -- ia,  a -- li -- lu -- ia, 

}

sopMusic = \relative c'' {
 r1 
 <<
  { 
   \voiceOne
    e4.^\markup "Ca    pe Îm-pă  -  ra   -  tul" e8 a,4 a d4. d8 e4 e
    fis4. fis8 fis4 fis e2. e4         
  }
  \new Voice = "split" {
   \voiceTwo
    r1 a,4. a8 cis4 cis d4. d8 d4 d cis2. cis4
  }
 >>
 \oneVoice
 d4 e fis d e( fis) g( e) e( d) cis8([ e d cis]) 
 d2 r2 r1 r r r2 r4 e, a1 a2 a a4. a8 a4 a d2( cis4) 
 c b2 a4 gis a2 cis d8 r
 a4( g) fis g1 fis4 d'( cis) d e1 d4 fis( e) d 
 d2^\markup"rall." cis d1 \fermata  
 \bar "|."
}

altMusic = \relative c'' {
 a4. a8 gis4 gis g2 g fis4. fis8 
 <<
  { 
   \voiceOne
    a4 a a4.
  }
   \new Voice = "split" {
    \voiceTwo
     e4 e d4.
  }
 >>
 \oneVoice
 a'8 a4 a a2. a4 a a a a b2. bes4 a2 a4.( g8) fis2 
 r r1 r r r r4
 cis( d e) fis4. fis8 g4( fis) e4. e8 e4 e a( fis g) 
 a g2 fis4 eis fis2 g fis8 r
 fis4( e) d e1 d4 fis( e) fis g1 fis4 
 a( g) fis b( bes a) g fis1 
}

tenorMusic = \relative c {
 r1 r r 
 <<
  { 
   \voiceOne
    fis'4. fis8
  }
   \new Voice = "split" {
    \voiceTwo
     d4. d8
  }
 >>
 \oneVoice
 d4 d cis2. cis4 d cis d a
 <<
  { 
   \voiceOne
    e'4( dis) e2 fis e8([ g fis e]) d2 b4\rest 
    cis e2. cis8 cis b2. cis8 cis fis2. d4 cis4. cis8 b4 
  }
   \new Voice = "split" {
    \voiceTwo
     b2. bes4 a2 a a b4\rest a cis2. 
     %\autoBeamOff
     a8 a gis2. a8 a a4( ais b) b a4. a8 gis4
  }
 >>
 \oneVoice
 r4 r a( b cis) d4. d8 e4( d) cis4. cis8 cis4 cis d2. 
 d4 d2 d4 d d2 e d8 r
 a2 a4
 <<
  { 
   \voiceOne
   %\skip 4 \skip 4 \skip 4
    e'4\rest cis^\markup"A  -  li  - lu" d e
  }
   \new Voice = "split" {
    \voiceTwo
     a,1 
  }
 >>
 \oneVoice
 a4 a2 a4
 <<
  { 
   \voiceOne
    e'4\rest cis^\markup"A  -  li  - lu" d e
  }
   \new Voice = "split" {
    \voiceTwo
     a,1 
  }
 >>
 \oneVoice
 a4 a( cis) d e2 <e a,>2 <d a>1 
}

bassMusic = \relative c {
 r1 r r d4. a8
 <<
  { 
   \voiceOne
    fis'4 fis
  }
   \new Voice = "split" {
    \voiceTwo
     d4 d
  }
 >>
 \oneVoice
 a'2. g4 fis e d fis g( fis) e( g) a2 a, d2 r r4
 a a' a,8 cis e2. a,8 a d2. b4 e4. e8 e4 r r2 r4
 a, d4. d8 cis4( d) a'4. a8 g4 g fis( d e)
 <<
  { 
   \voiceOne
    fis4 g2 a4 bes a2
  }
   \new Voice = "split" {
    \voiceTwo
     d,4 g,2 a4 bes a2 
  }
 >>
 \oneVoice
 a2 d4 r r2 r4
 a b cis d r r2 r4 a b cis d4
 <d d,>( <e e,>) <fis fis,> <g g,>2 <a a,> <d, d,>1 
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \sopMusic }
      \addlyrics { \sopWords }
    >>
    \new Staff <<
      \new Voice { \global \altMusic }
      \addlyrics { \altWords }
    >>
    \new Staff <<
      \clef "G_8"
      \new Voice { \global \tenorMusic }
      \addlyrics { \tenorWords }
    >>
    \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
      \addlyrics { \bassWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 60
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
